/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.CreativeModeTabBuilder;
import dev.gigaherz.jsonthings.things.misc.FlexCreativeModeTab;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.ItemVariantProvider;
import dev.gigaherz.jsonthings.util.parse.JParse;
import java.util.function.Consumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CreativeModeTabParser
extends ThingParser<CreativeModeTabBuilder> {
    public static final Logger LOGGER = LogManager.getLogger();

    public CreativeModeTabParser(IEventBus modBus) {
        super(GSON, "creative_mode_tab");
        modBus.addListener(this::registerTabs);
    }

    public void registerTabs(RegisterEvent event) {
        event.register(Registries.f_279569_, helper -> {
            LOGGER.info("Started registering Item things, errors about unexpected registry domains are harmless...");
            CreativeModeTabParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> {
                FlexCreativeModeTab tab = (FlexCreativeModeTab)thing.get();
                StackContext icon = tab.icon();
                String name = tab.name();
                CreativeModeTab.Builder builder = new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).m_257737_(() -> icon.toStack(null)).m_257941_((Component)Component.m_237115_((String)name)).m_257501_((parameters, output) -> {
                    for (ItemVariantProvider variantProvider : thing.getVariantProviders()) {
                        variantProvider.provideVariants((ResourceKey<CreativeModeTab>)ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)thing.getRegistryName()), output, parameters, null, true);
                    }
                });
                if (thing.getBefore() != null) {
                    builder = builder.withTabsAfter(thing.getBefore());
                }
                if (thing.getAfter() != null) {
                    builder = builder.withTabsBefore(thing.getAfter());
                }
                if (thing.getRightSide()) {
                    builder = builder.m_257826_();
                }
                helper.register(thing.getRegistryName(), (Object)builder.m_257652_());
            }, BaseBuilder::getRegistryName);
            LOGGER.info("Done processing thingpack CreativeModeTabs.");
        });
    }

    @Override
    protected void finishLoadingInternal() {
        this.getBuilders().forEach(BaseBuilder::get);
    }

    @Override
    protected CreativeModeTabBuilder processThing(ResourceLocation key, JsonObject data, Consumer<CreativeModeTabBuilder> builderModification) {
        CreativeModeTabBuilder builder = CreativeModeTabBuilder.begin(this, key);
        JParse.begin(data).key("icon", val -> val.ifString(str -> str.map(ResourceLocation::new).map(StackContext::new).handle(builder::setIcon)).ifObj(str -> str.map(name -> this.parseStackContext((JsonObject)name, true, true)).handle(builder::setIcon)).typeError()).ifKey("translation_key", val -> val.string().handle(builder::setTranslationKey)).ifKey("right_side", val -> val.bool().handle(builder::setRightSide)).ifKey("items", val -> val.array().forEach((index, entry) -> entry.ifString(str -> str.map(ResourceLocation::new).handle(builder::addItem)).ifObj(obj -> obj.map(name -> this.parseStackContext((JsonObject)name, true, true)).handle(builder::addItem)).typeError())).ifKey("before", val -> val.array().flatten(e -> (ResourceLocation)e.string().map(ResourceLocation::new).value(), ResourceLocation[]::new).handle(builder::setBefore)).ifKey("after", val -> val.array().flatten(e -> (ResourceLocation)e.string().map(ResourceLocation::new).value(), ResourceLocation[]::new).handle(builder::setAfter));
        builderModification.accept(builder);
        return builder;
    }
}

